/*
 *    Copyright 2009-2012 the original author or authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package cn.hperfect.nbquerier.core.transaction.jdbc;

import cn.hperfect.nbquerier.core.components.datasouce.INbDataSource;
import cn.hperfect.nbquerier.core.transaction.ITransactionFactory;
import cn.hperfect.nbquerier.core.transaction.TransactionIsolationLevel;

import java.sql.Connection;

/**
 * Creates {@link cn.hperfect.nbquerier.core.transaction.jdbc.JdbcTransaction} instances.
 *
 * @see cn.hperfect.nbquerier.core.transaction.jdbc.JdbcTransaction
 */
/**
 * @author Clinton Begin
 */

/**
 * JdbcTransaction工厂
 */
public class JdbcTransactionFactory implements ITransactionFactory {
  @Override
  public JdbcTransaction newTransaction(INbDataSource ds, TransactionIsolationLevel level, boolean autoCommit) {
    return new JdbcTransaction(ds, level, autoCommit);
  }

  @Override
  public JdbcTransaction newTransaction(Connection conn) {
    return null;
  }
}
