package cn.hperfect.nbquerier.core.transaction;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * 事务
 */
public interface INbTransaction extends Closeable {
    default Connection getConnection() throws SQLException{
        return getConnection(null);
    }

    /**
     * 获取连接
     *
     * @return
     * @throws SQLException
     */
    Connection getConnection(String dsName) throws SQLException;

    /**
     * 提交
     *
     * @throws SQLException
     */
    void commit() throws SQLException;

    /**
     * 回滚
     *
     * @throws SQLException
     */
    void rollback() throws SQLException;

    void setAutoCommit(boolean autoCommit) throws SQLException;
}
