package cn.hperfect.nbquerier.core.registry;

import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/4 10:28 上午
 */
public class ValidatorRegistry {
    /**
     * 校验器表
     */
    private static final Map<String, IValidator> registrationMap = new HashMap<>();

    public void put(IValidator iValidator) {
        String name = iValidator.getName();
        registrationMap.computeIfAbsent(name, n -> registrationMap.put(name, iValidator));
    }

    public static IValidator getValidator(String name) {
        return registrationMap.get(name);
    }
}
