package cn.hperfect.nbquerier.core.registry;

import cn.hperfect.nbquerier.core.components.interceptor.INbInterceptor;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hutool.core.collection.CollUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 查询拦截器器链
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 12:27 下午
 */
public class NbInterceptorRegistry implements INbInterceptor {

    List<INbInterceptor> registrations = new ArrayList<>();

    public void addInterceptor(INbInterceptor nbInterceptor) {
        this.registrations.add(nbInterceptor);
    }

    @Override
    public void doBeforeUpdate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (CollUtil.isNotEmpty(this.registrations)) {
            for (INbInterceptor interceptor : this.registrations) {
                interceptor.doBeforeUpdate(nbQueryInfo, dataList);
            }
        }
    }

    @Override
    public void doQueryBefore(NbQueryInfo nbQueryInfo) {
        if (CollUtil.isNotEmpty(this.registrations)) {
            for (INbInterceptor registration : this.registrations) {
                registration.doQueryBefore(nbQueryInfo);
            }
        }
    }

    @Override
    public void doBeforeSave(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (CollUtil.isNotEmpty(this.registrations)) {
            for (INbInterceptor interceptor : this.registrations) {
                interceptor.doBeforeSave(nbQueryInfo, dataList);
            }
        }
    }
}
