package cn.hperfect.nbquerier.core.querier.execute;

import cn.hperfect.nbquerier.core.metedata.custom.BaseCustomEntity;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.querier.condition.DoLambdaCondition;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 跟新保存操作
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 10:49 上午
 */
public interface DoUpdate<T> extends DoLambdaCondition<T> {
    /**
     * 更新数据
     *
     * @param updateData
     * @return
     */
    default int update(Map<String, Object> updateData) {
        if (CollUtil.isEmpty(updateData)) {
            return 0;
        }
        boolean allowSetNull = getQueryInfo().isAllowSetNull();
        //不支持更新主键
        if (getQueryInfo().isClass()) {
            mapFieldAlias(updateData, true);
        }

        updateData.forEach((k, v) -> {
            if (v != null || allowSetNull) {
                this.set(k, v);
            }
        });
        return this.update();
    }

    /**
     * 保存
     *
     * @param t
     * @return
     */
    default <F extends T> int save(F t) {
        return save(beanToMap(t));
    }

    /**
     * 生成一条语句保存
     *
     * @param list
     * @return
     */
    default int saveBatch(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return 0;
        }
        List<Map<String, Object>> dataList = new ArrayList<>();
        for (T t : list) {
            dataList.add(beanToMap(t));
        }
        return saveBatchMap(dataList);
    }

    /**
     * 通过id更新
     *
     * @param t
     * @return
     */
    default int updateById(T t) {
        Map<String, Object> map = beanToMap(t);
        return updateById(map);
    }

    default int updateById(Map<String, Object> map) {
        String pkName = getPkName();
        Object pkValue = map.get(pkName);
        Assert.notNull(pkValue, "id:{},值不能为空", pkName);
        where(pkName, pkValue, true);
        if (CollUtil.isEmpty(map)) {
            return 0;
        }
        return update(map);
    }

    default int saveOrUpdate(T t) {
        return saveOrUpdate(t, true);
    }

    /**
     * 更新或保存
     *
     * @param t
     * @param checkExist 是否判断 id是否存在
     * @return
     */
    default int saveOrUpdate(T t, boolean checkExist) {
        if (t == null) {
            return 0;
        }
        Map<String, Object> map = beanToMap(t);
        Object pkValue = map.get(getPkName());
        boolean update = pkValue != null;
        if (update && checkExist) {
            update = NbQuerier.table(getQueryInfo()).wherePk(pkValue).exist();
        }
        if (update) {
            return wherePk(pkValue).update(map);
        } else {
            return save(map);
        }
    }

    int update(boolean isDelete);

    /**
     * 执行更新
     *
     * @return
     */
    default int update() {
        return update(false);
    }

    int delete();

    default int delete(Object pkValue) {
        this.wherePk(pkValue);
        return delete();
    }

    int save(Map<String, Object> data);


    default int save(BaseCustomEntity data) {
        //重新获取值
        return save(data.getDataMap());
    }

    /**
     * 批量保存
     *
     * @param dataList
     * @return
     */

    int saveBatchMap(List<Map<String, Object>> dataList);

    /**
     * 设置更新数据
     *
     * @param field
     * @param value
     * @return
     */
    NbQuerier<T> set(String field, Object value);

    default <V> NbQuerier<T> set(SFunction<T, V> field, V value, boolean notNull) {
        if (notNull) {
            Assert.notNull(value, "设置字段:{},值不能为空", field);
        }
        return set(field, value);
    }

    default <V> NbQuerier<T> set(SFunction<T, V> field, V value) {
        return set(getFieldName(field), value);
    }

}
