package cn.hperfect.nbquerier.core.querier.execute;

import cn.hperfect.nbquerier.core.querier.condition.DoLambdaCondition;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 执行相关接口
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 10:45 上午
 */
public interface DoSelect<T> extends DoLambdaCondition<T> {
    @Nullable
    default LinkedHashMap<String, Object> findMap() {
        return findMap(true);
    }

    /**
     * 查找一个map
     *
     * @param assertOne
     * @return
     */
    default LinkedHashMap<String, Object> findMap(boolean assertOne) {
        this.limit(1);
        return selectOne(assertOne);
    }

    /**
     * 查询map转驼峰
     *
     * @return
     */
    default List<Map<String, Object>> selectMapToCamelCase() {
        List<Map<String, Object>> mapList = new ArrayList<>();
        List<LinkedHashMap<String, Object>> list = selectMap();
        if (CollUtil.isNotEmpty(list)) {
            mapList = list.stream()
                    .map(i -> i == null ? null : MapUtil.toCamelCaseMap(i))
                    .collect(Collectors.toList());
        }
        return mapList;
    }

    default Map<String, Object> findMapToCamelCase() {
        LinkedHashMap<String, Object> map = findMap(true);
        return map != null ? MapUtil.toCamelCaseMap(map) : null;
    }

    /**
     * 执行查询
     *
     * @return
     */
    List<T> select();

    /**
     * 根据主键查找，必须要有@TableIdfind(Object pkValue)
     *
     * @param pkValue
     * @return
     */
    default T find(Object pkValue) {
        return wherePk(pkValue).find();
    }


    /**
     * 查找一个值
     *
     * @return
     */
    T find();

    /**
     * 查某列数据
     *
     * @param <F>
     * @return
     */
    <F> List<F> column(String field);

    default <F> List<F> column(SFunction<T, ?> field) {
        return column(getFieldName(field));
    }


    /**
     * 查询为map
     *
     * @return
     */
    List<LinkedHashMap<String, Object>> selectMapList();


    List<LinkedHashMap<String, Object>> selectMap();

    /**
     * 自定义class返回
     *
     * @param clazz
     * @param <F>
     * @return
     */
    <F> List<F> select(Class<F> clazz);

    /**
     * 查询一个值
     *
     * @param assertOne 大于一抛出异常
     * @return
     */
    LinkedHashMap<String, Object> selectOne(boolean assertOne);

    /**
     * 构建查询sql
     *
     * @return
     */
    String buildQuerySql();

    /**
     * 构建聚合查询sql
     *
     * @param funcName
     * @return
     */
    String buildFuncSql(String funcName);


}
