package cn.hperfect.nbquerier.core.querier.execute;

import cn.hperfect.nbquerier.core.conditions.ILaterQuerier;
import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.ResultType;
import cn.hperfect.nbquerier.toolkit.support.SFunction;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 10:50 上午
 */
public interface DoFunction<T> extends DoSelect<T> {

    default int count() {
        return count(true);
    }

    int count(boolean page);

    /**
     * 条件聚合
     *
     * @param coalesce 是否null 替换成0
     * @return
     */
    NbQuerier<T> conditionCount(ILaterQuerier querier, String alias, boolean coalesce);

    NbQuerier<T> addConditionAgg(ISqlSegment count, String alias);

    /**
     * 求和
     *
     * @param field
     * @return
     */

    double sum(String field);

    default double sum(SFunction<T, ?> function) {
        return sum(getFieldName(function));
    }

    /**
     * 查询总数,忽略page参数
     *
     * @return
     */
    default int total() {
        return count(false);
    }

    /**
     * 是否存在该记录
     *
     * @return
     */
    boolean exist();

    /**
     * 替换字段查询
     *
     * @param funcName
     * @param type
     * @param <F>
     * @return
     */
    <F> F func(String funcName, ResultType type, boolean limit);
}
