package cn.hperfect.nbquerier.core.querier.condition;

import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.QueryFields;
import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.util.StrUtil;

import java.util.List;
import java.util.Map;

/**
 * 查询最顶层接口
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 1:30 下午
 */
public interface NbQuerierTopside<T> {
    /**
     * 获取查询信息
     *
     * @return
     */
    NbQueryInfo getQueryInfo();

    /**
     * 获取所有表别名
     *
     * @return
     */

    BiMap<String, String> getTableAliasMap();

    /**
     * 获取表别名
     * @param tableName
     * @return
     */
    default String getTableAlias(String tableName) {
        return getTableAliasMap().get(tableName);
    }

    /**
     * 结果集class
     * @return
     */

    Class<T> getResultClass();

    QueryFields getQueryFields();

    /**
     * 将对象转为map
     *
     * @param bean
     * @return
     */
    Map<String, Object> beanToMap(T bean);

    /**
     * 结果转换成对象
     *
     * @param map
     * @return
     */
    T mapToBean(Map<String, Object> map);

    /**
     * 获取主键名称
     *
     * @return
     */

    default String getPkName() {
        return getQueryInfo().getPkName();
    }

    /**
     * @param map
     * @param beanToMap 保存时候替换
     */
    default void mapFieldAlias(Map<String, Object> map, boolean beanToMap) {
        for (INbField field : getQueryInfo().getFields()) {
            if (field instanceof ClassNbField) {
                String propName = ((ClassNbField) field).getPropName();
                String fn = StrUtil.toUnderlineCase(propName);
                String name = field.getName();
                if (StrUtil.isNotBlank(field.getAlias())) {
                    name = field.getAlias();
                }
                if (!fn.equals(name)) {
                    if (beanToMap) {
                        map.put(name, map.get(fn));
                        map.remove(fn);
                    } else {
                        map.put(fn, map.get(name));
                        map.remove(name);
                    }
                }
            }
        }
    }

    /**
     * 解析字段名称,默认带表别名
     *
     * @param function
     * @return
     */
    default <G, K> String getFieldName(SFunction<G, K> function) {
        return getFieldName(function, true);
    }

    <G, K> String getFieldName(SFunction<G, K> function, boolean withAlias);

    default String[] getFieldNames(List<SFunction<T, ?>> fields) {
        String[] sField = new String[fields.size()];
        for (int i = 0; i < fields.size(); i++) {
            sField[i] = getFieldName(fields.get(i));
        }
        return sField;
    }
}
