package cn.hperfect.nbquerier.core.querier.condition;


import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.toolkit.support.SFunction;
import cn.hutool.core.collection.ListUtil;

import java.util.Collection;
import java.util.List;

/**
 * DoLambda 条件
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 9:38 上午
 */
public interface DoLambdaCondition<T> extends DefaultDoCondition<T> {

    default <G extends T, V> NbQuerier<T> where(SFunction<G, V> field, V value) {
        return where(field, value, false);
    }

    default <V> NbQuerier<T> whereBt(SFunction<T, V> field, V startValue, V endValue) {
        return where(getFieldName(field), QueryRuleEnum.BETWEEN, ListUtil.toList(startValue, endValue), false);
    }

    default <V> NbQuerier<T> whereNotNull(SFunction<T, V> field) {
        return whereNotNull(getFieldName(field));
    }

    default <V> NbQuerier<T> whereOrNull(SFunction<T, V> field, V value) {
        return whereOrNull(getFieldName(field), value);
    }

    default NbQuerier<T> whereNull(SFunction<T, ?> field) {
        return whereNull(getFieldName(field));
    }


    default <V> NbQuerier<T> where(SFunction<? extends T, V> field, V value, boolean notNull) {
        return where(getFieldName(field), value, notNull);
    }

    default <V> NbQuerier<T> whereLike(SFunction<T, V> field, String search) {
        return whereLike(getFieldName(field), search);
    }

    default <V> NbQuerier<T> whereLikeLeft(SFunction<T, V> field, String search) {
        return whereLikeLeft(getFieldName(field), search);
    }

    default <V> NbQuerier<T> whereLikeRight(SFunction<T, V> field, String search) {
        return whereLikeRight(getFieldName(field), search);
    }

    default <V> NbQuerier<T> where(SFunction<T, V> field, String condition, V value) {
        return where(getFieldName(field), condition, value);
    }

    default <V> NbQuerier<T> whereInters(SFunction<T, V> field, V list) {
        return whereInters(getFieldName(field), (Collection<?>) list);
    }

    default <V> NbQuerier<T> whereIn(SFunction<T, V> field, Collection<V> list) {
        return whereIn(getFieldName(field), list);
    }

    default <V> NbQuerier<T> whereIn(SFunction<T, V> field, Collection<?> list, boolean notNull) {
        return whereIn(getFieldName(field), list, notNull);
    }

    default <V> NbQuerier<T> whereNotIn(SFunction<T, V> field, Collection<?> list) {
        return whereNotIn(getFieldName(field), list);
    }

    default <V> NbQuerier<T> whereNotIn(SFunction<T, V> field, NbQuerier<?> querier) {
        return whereNotIn(getFieldName(field), querier);
    }

    default <V> NbQuerier<T> whereIn(SFunction<T, V> field, NbQuerier<?> querier) {
        return whereIn(getFieldName(field), querier);
    }

    default <V> NbQuerier<T> whereAny(SFunction<T, V> field, Object value) {
        return whereAny(getFieldName(field), value);
    }

    default <V> NbQuerier<T> whereNotAny(SFunction<T, V> field, Object value) {
        return whereNotAny(getFieldName(field), value);
    }

    default <V> NbQuerier<T> whereAny(SFunction<T, V> field, Object value, boolean required) {
        return whereAny(getFieldName(field), value, required);
    }

    default <F> NbQuerier<T> desc(SFunction<T, F> field) {
        return desc(getFieldName(field));
    }

    default <F> NbQuerier<T> asc(SFunction<T, F> field) {
        return asc(getFieldName(field));
    }

    default NbQuerier<T> desc(List<SFunction<T, ?>> fields) {
        return desc(getFieldNames(fields));
    }

    default NbQuerier<T> asc(List<SFunction<T, ?>> fields) {
        return asc(getFieldNames(fields));
    }

}
