package cn.hperfect.nbquerier.core.querier.condition;

import cn.hperfect.nbquerier.core.metedata.IQueryItem;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.NbOrderType;
import cn.hperfect.nbquerier.enums.NullsPosition;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hutool.json.JSONObject;
import org.springframework.lang.Nullable;

import java.util.function.Consumer;

/**
 * where 条件
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 10:53 上午
 */
public interface DoConditionTopside<T> extends NbQuerierTopside<T> {
    /**
     * 直接拼接where语句
     * 重要: 避免直接使用字符串参数拼接,否则会造成sql注入
     * 如需拼接字符串参数,请使用 formatVariable 格式化变量
     *
     * @param sql
     * @return
     */
    NbQuerier<T> where(String sql);

    /**
     * qrs 查询json表达式
     *
     * @param jsonObject
     * @return
     */
    NbQuerier<T> whereQrs(JSONObject jsonObject);


    /**
     * 排序
     *
     * @param sort
     * @param fields
     * @return
     */
    default NbQuerier<T> order(NbOrderType sort, String... fields){
        return order(sort, null, fields);
    }

    NbQuerier<T> order(NbOrderType sort, @Nullable NullsPosition nullsPosition, String... fields);

    /**
     * or 连接
     *
     * @return
     */
    NbQuerier<T> or();

    /**
     * not 连接
     *
     * @return
     */
    NbQuerier<T> not();

    /**
     * where 入口,所有条件通过这个方法
     *
     * @param field
     * @param ruleEnum
     * @param value
     * @param notNull  是否允许value为空
     * @return
     */
    NbQuerier<T> where(String field, QueryRuleEnum ruleEnum, Object value, boolean notNull);

    NbQuerier<T> where(IQueryItem iQueryItem, QueryRuleEnum ruleEnum, Object value, boolean notNull);


    /**
     * 传入对象查询
     *
     * @param t
     * @return
     */
    NbQuerier<T> where(T t);

    /**
     * 嵌套查询,会自动加括号
     *
     * @param consumer
     * @return
     */
    NbQuerier<T> where(Consumer<NbQuerier<T>> consumer);
    NbQuerier<T> whereExists(NbQuerier<?> querier);
    NbQuerier<T> whereIn(String field, NbQuerier<?> querier);

    NbQuerier<T> whereNotIn(String field, NbQuerier<?> querier);

    /**
     * 不同方言的limit方法
     *
     * @param offset
     * @param length
     * @return
     */
    NbQuerier<T> limit(int offset, int length);

    /**
     * 加入最后
     *
     * @param last
     * @return
     */
    NbQuerier<T> last(java.lang.String last);

    /**
     * 获取数据库类型
     *
     * @return
     */
    DbType getDbType();

    /**
     * 替换sql参数
     *
     * @param sql
     * @param params
     * @return
     */

    String parseSqlParam(String sql, QueryValParam... params);

}
