package cn.hperfect.nbquerier.core.querier;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 对结果处理(钩子)
 * //todo 加入多线程处理
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/29 1:57 下午
 */
public interface IResultMap<T> {
    /**
     * 查询结果map处理
     *
     * @param doAfter
     * @return
     */
    NbQuerier<T> doAfterForMapList(Consumer<List<LinkedHashMap<String, Object>>> doAfter);


    /**
     * select 之后对item操作
     *
     * @param doAfterForItem
     * @return
     */
    NbQuerier<T> doAfterForItem(Consumer<T> doAfterForItem);

    /**
     * 对map处理
     *
     * @param doAfterForItemMap
     * @return
     */
    NbQuerier<T> doAfterForItemMap(Consumer<LinkedHashMap<String, Object>> doAfterForItemMap);

    /**
     * select 执行后都对数据处理
     *
     * @param doAfter
     * @return
     */
    NbQuerier<T> doAfterForList(Consumer<List<T>> doAfter);

    default <V> NbQuerier<T> doAfterForListMap(Function<? super T, V> keyMapper, Consumer<Map<V, T>> doAfter) {
        return doAfterForList(list -> doAfter.accept(list.stream().collect(Collectors.toMap(keyMapper, i -> i))));
    }
}
