package cn.hperfect.nbquerier.core.metedata.table;

import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.List;

/**
 * 用于子查询的虚拟表
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/12/10 6:19 下午
 */
@Data
@AllArgsConstructor
public class VirtualTable implements INbTable {

    private String tableName;
    /**
     * 主表
     */
    private String masterTable;
    private PrimaryKey pk;
    List<? extends INbField> fields;

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public String getDs() {
        return null;
    }

    @Override
    public INbField getDeleteField() {
        return null;
    }

    @Override
    public INbField getOrderField() {
        return null;
    }

    @Override
    public INbField getPermField() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public List<? extends INbField> getFields() {
        return fields;
    }
}
