package cn.hperfect.nbquerier.core.metedata.table;

import cn.hperfect.nbquerier.core.metedata.OrderInfo;
import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.enums.perm.PermType;
import cn.hutool.core.collection.CollUtil;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/27 10:51 上午
 */
@Data
@Accessors(chain = true)
public class ClassNbTable implements INbTable {

    private String tableName;

    private final Class<?> tableClass;

    /**
     * 表字段
     */
    private List<ClassNbField> fields;

    /**
     * schema
     */
    private String schema;
    /**
     * 选择数据项
     */
    private String ds;

    /**
     * 软删除字段
     */
    private ClassNbField deleteField;


    /**
     * 权限类型
     */
    private PermType permType;

    /**
     * 主键
     */
    private PrimaryKey pk;

    private String description;
    /**
     * 排序信息
     */
    private List<OrderInfo> orderInfos;

    @Override
    public ClassNbField getOrderField() {
        return CollUtil.findOne(fields, i -> i.getFieldType() == NbFieldType.ORDER);
    }

    @Override
    public INbField getPermField() {
        return CollUtil.findOne(fields, i -> i.getName().equals("user_id"));
    }
}
