package cn.hperfect.nbquerier.core.metedata.querier;

import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hperfect
 * @date 2022/12/17 21:34
 */
@Data
public class UpdateData {
    /**
     * 更新数据
     */
    private Map<INbField, Object> updateDataMap = new HashMap<>();

    private List<String> updateExprList = new ArrayList<>();

    public void clear() {
        updateDataMap.clear();
        updateExprList.clear();
    }

    public void put(INbField field, Object data) {
        updateDataMap.put(field, data);

    }

    /**
     * 添加表达式
     *
     * @param expr
     */
    public void addExpr(String expr) {
        this.updateExprList.add(expr);
    }
}
