package cn.hperfect.nbquerier.core.metedata.inter;

import cn.hperfect.nbquerier.core.metedata.OrderInfo;
import cn.hperfect.nbquerier.core.metedata.PrimaryKey;
import cn.hperfect.nbquerier.enums.perm.PermType;

import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/28 12:38 下午
 */
public interface INbTable {
    /**
     * 获取表名
     *
     * @return
     */
    String getTableName();

    /**
     * 表所在的schema
     *
     * @return
     */
    String getSchema();

    /**
     * 数据源
     *
     * @return
     */
    String getDs();

    /**
     * 获取主键
     *
     * @return
     */
    PrimaryKey getPk();


    /**
     * 软删除字段
     */
    INbField getDeleteField();

    /**
     * 排序字段
     */
    INbField getOrderField();

    /**
     * 权限字段
     *
     * @return
     */
    INbField getPermField();

    /**
     * 获取数据域字段,默认权限字段
     *
     * @return
     */
    default INbField getDataScopeField() {
        return getPermField();
    }

    /**
     * 获取权限类型
     *
     * @return
     */
    default PermType getPermType() {
        return null;
    }

    /**
     * 表单的表述信息
     *
     * @return
     */
    String getDescription();

    /**
     * 更新和保存时替换
     * (通常用于更新视图对应的表)
     *
     * @return
     */
    default String getReplaceTable() {
        return null;
    }

    /**
     * 获取排序信息
     *
     * @return
     */
    default List<OrderInfo> getOrderInfos() {
        return null;
    }

    List<? extends INbField> getFields();

}
