package cn.hperfect.nbquerier.core.metedata.inter;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hutool.core.util.StrUtil;

import java.io.Serializable;
import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/28 12:36 下午
 */
public interface INbField extends Serializable {
    /**
     * 数据库字段名称(可能是函数)
     */
    String getName();

    /**
     * 获取表名
     *
     * @return
     */
    String getTableName();

    /**
     * 字段查询类型
     */
    INbQueryType getQueryType();

    /**
     * 获取校验规则
     *
     * @return
     */
    List<ValidateRule> getValidateRules();

    /**
     * 字段类型
     */
    NbFieldType getFieldType();

    /**
     * 字段填充策略
     */
    FillStrategy getFillStrategy();

    default String getRedirect() {
        return null;
    }

    default String getRedirectOrName() {
        return StrUtil.isBlank(getRedirect()) ? getName() : getRedirect();
    }

    default boolean isInsertDefault() {
        return false;
    }

    default String getDescription() {
        return null;
    }

    /**
     * 是否查询
     *
     * @return
     */
    default boolean isQuery() {
        return true;
    }

    /**
     * 是否是保存字段
     *
     * @return
     */
    default boolean isSave() {
        if (getQueryType() == NbQueryType.FUNC) {
            return false;
        }
        return true;
    }

    /**
     * 是否是主键
     *
     * @return
     */

    default boolean isPk() {
        return getFieldType() == NbFieldType.PK;
    }
    default boolean isFk() {
        return getFieldType() == NbFieldType.FK;
    }

    /**
     * 获取关联表单,todo 待优化(class 特有)
     *
     * @return
     */
    default INbTable getJoinTable() {
        return null;
    }

    default String getAlias() {
        return null;
    }

    boolean isNotNull();
}
