package cn.hperfect.nbquerier.core.metedata.field;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.List;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/12/4 10:44 上午
 */
@Data
@AllArgsConstructor
public class DeleteField implements INbField {

    private String name;

    private INbTable table;

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public NbQueryType getQueryType() {
        return NbQueryType.DATE;
    }

    @Override
    public List<ValidateRule> getValidateRules() {
        return null;
    }

    @Override
    public NbFieldType getFieldType() {
        return NbFieldType.DELETE;
    }

    @Override
    public FillStrategy getFillStrategy() {
        return null;
    }

    @Override
    public String getDescription() {
        return "删除时间";
    }

    @Override
    public boolean isNotNull() {
        return false;
    }
}
