package cn.hperfect.nbquerier.core.metedata.field;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hutool.core.util.BooleanUtil;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 10:05 上午
 */
@Data
public class ClassNbField implements INbField {
    /**
     * 数据库字段名称(可能是函数)
     */
    private String name;
    /**
     * alias->
     * 类的字段名称(更新保存时需要用到)
     */
    private String propName;

    /**
     * 所属表名(默认,null 为主表名)
     */
    private INbTable table;

    /**
     * 字段查询类型
     */
    private INbQueryType queryType;
    /**
     * 属性类
     */
    private Map<String, Object> enumMap;
    /**
     * 字段类型
     */
    private NbFieldType fieldType;
    /**
     * 字段填充策略
     */
    private FillStrategy fillStrategy;
    /**
     * 外键的连表信息
     */
    private INbTable joinTable;
    /**
     * 字段描述信息
     */
    private String description;
    /**
     * 字段别名
     */
    private String alias;

    private List<ValidateRule> validateRules;

    private Boolean notNull;

    private boolean insertDefault;

    @Override
    public String getTableName() {
        if (table != null) {
            return table.getTableName();
        }
        return null;
    }

    @Override
    public boolean isNotNull() {
        return BooleanUtil.isTrue(notNull);
    }
}
