package cn.hperfect.nbquerier.core.metedata.custom;

import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import lombok.Getter;

import java.lang.reflect.Type;
import java.util.*;

/**
 * copy to bean 的时候会移除值
 * 所以先copy 到bean ,再把剩下的 存到 自定义 数据中
 */
public class RemoveValueMapProvider extends HashMap<String, Object> implements ValueProvider<Object> {

    /**
     * 移除字段列表
     */
    @Getter
    private Set<String> removedFields = new HashSet<>();

    public RemoveValueMapProvider() {
        super();
    }

    public RemoveValueMapProvider(Map<String, Object> m) {
        super(m);
    }

    /**
     * 只能调用一次
     *
     * @param key       Bean对象中参数名
     * @param valueType 被注入的值的类型
     * @return
     */
    @Override
    public Object value(Object key, Type valueType) {
        Assert.isFalse(CollUtil.contains(removedFields, key), "key:{} 已去过值了", key);
        removedFields.add(Convert.toStr(key));
        /*if (BaseCustomEntity.class.isAssignableFrom((Class<?>) valueType)) {

        }*/
        return Convert.convertWithCheck(valueType, remove(key), null, true);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public int getRemovedSize() {
        return removedFields.size();
    }
}
