package cn.hperfect.nbquerier.core.metedata.custom;

import cn.hutool.core.util.ReflectUtil;
import lombok.SneakyThrows;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * 构建工厂
 */
public class CustomEntityBuilder {

    private static final Method initByMap = ReflectUtil.getMethod(BaseCustomEntity.class, "initByMap", Map.class);
    private static final Method initByProvider = ReflectUtil.getMethod(BaseCustomEntity.class, "initByProvider", RemoveValueMapProvider.class);

    /**
     * provider 必须全为驼峰
     *
     * @param clazz
     * @param provider
     * @param <T>
     * @return
     */
    @SneakyThrows
    public static <T> T newInstanceByProvider(Class<T> clazz, RemoveValueMapProvider provider) {
        T t = ReflectUtil.newInstance(clazz);
        initByProvider.invoke(t, provider);
        return t;
    }

    @SneakyThrows
    public static <T> T newInstance(Class<T> clazz, Map<String, Object> map) {
        T t = ReflectUtil.newInstance(clazz);
        initByMap.invoke(t, map);
        return t;
    }

}
