package cn.hperfect.nbquerier.core.metedata;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 校验规则
 *
 * @author huanxi
 * @version 1.0
 * @date 2022/1/7 12:01 下午
 */
@Data
public class ValidateRule implements Serializable {
    static final long serialVersionUID = -1L;

    /**
     * 校验验证器名字,必须注册
     */
    private String name;
    /**
     * 非法提示信息
     */
    private String msg;
    /**
     * 校验参数，如长度校验器，需要传最大长度
     */
    private Map<String, Object> params;

    public ValidateRule(String name) {
        this.name = name;
    }

    public ValidateRule(String name, Map<String, Object> params) {
        this.name = name;
        this.params = params;
    }
}
