package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.querier.IResultMap;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hutool.core.collection.CollUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@Data
public class ResultConsumer<T> implements IResultMap<T> {
    /**
     * select查询完后对对象结果集操作
     */
    private Consumer<List<T>> doAfterForList;
    /**
     * 对查询出的对象做操作
     */
    private List<Consumer<T>> doAfterForItemConsumers;

    private List<Consumer<LinkedHashMap<String, Object>>> doAfterForItemMapConsumers;

    /**
     * selectMap查询完后对Map结果集操作
     */
    private List<Consumer<List<LinkedHashMap<String, Object>>>> doAfterForMapListConsumers;

    /**
     * map操作
     *
     * @param resultList
     */
    public void doMapList(List<LinkedHashMap<String, Object>> resultList) {
        if (CollUtil.isNotEmpty(this.doAfterForMapListConsumers)) {
            for (Consumer<List<LinkedHashMap<String, Object>>> doAfterForMapListConsumer : this.doAfterForMapListConsumers) {
                doAfterForMapListConsumer.accept(resultList);
            }
        }
        if (CollUtil.isNotEmpty(this.doAfterForItemMapConsumers)) {
            for (Consumer<LinkedHashMap<String, Object>> doAfterForItemConsumer : doAfterForItemMapConsumers) {
                resultList.forEach(doAfterForItemConsumer);
            }
        }
    }

    public void doBeanList(List<T> list) {
        if (doAfterForList != null) {
            doAfterForList.accept(list);
        }
        if (CollUtil.isNotEmpty(doAfterForItemConsumers)) {
            for (Consumer<T> tConsumer : doAfterForItemConsumers) {
                list.forEach(tConsumer);
            }
        }
    }

    @Override
    public NbQuerier<T> doAfterForMapList(Consumer<List<LinkedHashMap<String, Object>>> doAfter) {
        if (doAfterForMapListConsumers == null) {
            doAfterForMapListConsumers = new ArrayList<>();
        }
        doAfterForMapListConsumers.add(doAfter);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForItem(Consumer<T> doAfterForItem) {
        if (this.doAfterForItemConsumers == null) {
            this.doAfterForItemConsumers = new ArrayList<>();
        }
        this.doAfterForItemConsumers.add(doAfterForItem);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForItemMap(Consumer<LinkedHashMap<String, Object>> doAfterForItemMap) {
        if (this.doAfterForItemMapConsumers == null) {
            this.doAfterForItemMapConsumers = new ArrayList<>();
        }
        this.doAfterForItemMapConsumers.add(doAfterForItemMap);
        return null;
    }

    @Override
    public NbQuerier<T> doAfterForList(Consumer<List<T>> doAfter) {
        this.doAfterForList = doAfter;
        return null;
    }

    public void doMap(LinkedHashMap<String, Object> map) {
        if (CollUtil.isNotEmpty(doAfterForItemMapConsumers)) {
            for (Consumer<LinkedHashMap<String, Object>> doAfterForItemMapConsumer : doAfterForItemMapConsumers) {
                doAfterForItemMapConsumer.accept(map);
            }
        }
    }
}
