package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.core.components.type.NbQueryType;
import cn.hperfect.nbquerier.core.type.JsonNbType;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.Collection;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 2:14 下午
 */
@Data
@AllArgsConstructor
public class QueryValParam {
    private INbQueryType type;
    private Object value;


    public static QueryValParam stringVal(String str) {
        return new QueryValParam(NbQueryType.TEXT, str);
    }

    public static QueryValParam jsonbVal(Object value) {
        return new QueryValParam(new JsonNbType(), value);
    }

    public static QueryValParam longListVal(Collection<Long> val) {
        return new QueryValParam(NbQueryType.LONG_LIST, val);
    }
    public static QueryValParam strListVal(Collection<String> val) {
        return new QueryValParam(NbQueryType.TEXT_LIST, val);
    }
    public static QueryValParam longVal(Long val) {
        return new QueryValParam(NbQueryType.LONG, val);
    }
    public static QueryValParam intVal(Integer val) {
        return new QueryValParam(NbQueryType.INT, val);
    }
    public static QueryValParam boolVal(boolean b) {
        return new QueryValParam(NbQueryType.BOOL, b);
    }
}
