package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hperfect.nbquerier.toolkit.StringPool;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 查询item
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/30 5:45 下午
 */
@Data
@NoArgsConstructor
@Accessors(chain = true)
public class QueryItem implements IQueryItem {
    /**
     * 字段的名称
     */
    private String name;
    /**
     * 字段的表，或者表别名
     */
    private String tableAlias;
    private String fieldAlias;
    private boolean isFunc;

    private String funcName;

    private List<QueryItem> params;

    private QueryField queryField;

    private String sql;
    private boolean sub;

    public QueryItem(String alias, String field) {
        this.tableAlias = alias;
        this.name = field;
    }



    @Deprecated
    public QueryItem(String field) {
        this.funcName = ReUtil.get("(.*)\\((.*)\\)", field, 1);
        if (StrUtil.isNotBlank(funcName)) {
            this.isFunc = true;
            this.name = field;
        } else if (StrUtil.contains(field, StringPool.DOT)) {
            String[] split = field.split("\\.");
            this.tableAlias = StrUtil.toUnderlineCase(split[0]);
            this.name = split[1];
            if (StrUtil.containsAnyIgnoreCase(this.name, " as ")) {
                String[] splitName = this.name.split(StringPool.SPACE, 2);
                this.name = splitName[0];
                this.fieldAlias = splitName[1];
            }
        } else {
            this.name = field;
        }
        Assert.notEmpty(this.name, "字段名称不能为空");
        this.name = StrUtil.toUnderlineCase(this.name);
    }

    /**
     * 查询表达式
     */
    @Override
    public String getExpr(String alias) {
        if (sql != null) {
            return sql;
        }
        if (isFunc) {
            //计算表达式
            String param = StringPool.EMPTY;
            if (CollUtil.isNotEmpty(params)) {
                return StrUtil.join(",", params.stream().map(QueryItem::getExpr).collect(Collectors.toList()));
            }
            return StrUtil.format("{}({})", funcName, param);
        }
        //name 处理
        String res = SqlUtils.withAlias(alias, this.name);
        if (StrUtil.isNotBlank(fieldAlias)) {
            res = res + StringPool.SPACE + fieldAlias;
        }
        return res;
    }

    @Override
    public String getExpr() {
        return getExpr(tableAlias);
    }


    public void addParam(QueryItem param) {
        if (params == null) {
            params = new ArrayList<>();
        }
        params.add(param);
    }

    public QueryItem getLastParam() {
        return CollUtil.getLast(params);
    }
}
