package cn.hperfect.nbquerier.core.metedata;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.lang.Nullable;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author hperfect
 * @date 2022/12/15 20:41
 */
public class QueryFields {
    /**
     * name set
     */
    Map<String, Set<QueryField>> fieldsMap = new HashMap<>();

    List<QueryField> fields = null;

    public QueryFields() {
    }

    public QueryFields(Collection<QueryField> fields) {
        this.puts(fields);
    }

    public Collection<QueryField> fields() {
        if (fields == null) {
            fields = fieldsMap.values()
                    .stream()
                    .flatMap(Collection::stream)
                    .collect(Collectors.toList());
        }
        return fields;
    }

    public void puts(Collection<QueryField> fields) {
        if (CollUtil.isNotEmpty(fields)) {
            for (QueryField field : fields) {
                Set<QueryField> queryFields = ifAbsentCreate(field.getName());
                queryFields.add(field);
            }
        }
    }

    private Set<QueryField> ifAbsentCreate(String name) {
        return fieldsMap.computeIfAbsent(name, k -> new HashSet<>());
    }

    public Collection<QueryField> findByName(String fieldName) {
        return fieldsMap.get(fieldName);
    }

    public void puts(QueryFields queryFields) {
        queryFields.fieldsMap.forEach((k, v) -> ifAbsentCreate(k).addAll(v));
    }

    @Nullable
    public QueryField find(String name, String table) {
        Set<QueryField> queryFields = fieldsMap.get(name);
        if (CollUtil.isNotEmpty(queryFields)) {
            for (QueryField queryField : queryFields) {
                if (StrUtil.equals(table, queryField.getTableName())) {
                    return queryField;
                }
            }
        }
        return null;
    }

    public void add(QueryField queryField) {
        ifAbsentCreate(queryField.getName()).add(queryField);
    }
}
