package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Objects;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 4:52 下午
 */

@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Data
public class QueryField {
    /**
     * 查询类型
     */
    private INbQueryType type;
    /**
     * 查询名称
     */
    private String name;
    /**
     * 表名
     */
    private String tableName;
    /**
     * 上级名称
     */
    private String wrpTable;
    /**
     * 查询重定向
     */
    private String redirect;
    /**
     * 条件重定向
     */
    private String whereRedirect;
    /**
     * 排序重定向
     */
    private String orderRedirect;

    public QueryField(INbQueryType type, String name, String tableName, String wrpTable, String redirect) {
        this.type = type;
        this.name = name;
        this.tableName = tableName;
        this.wrpTable = wrpTable;
        this.redirect = redirect;
    }

    /**
     * 同一个表同一个字段认为相同
     *
     * @param o
     * @return
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryField that = (QueryField) o;
        return Objects.equals(name, that.name)
                && Objects.equals(tableName, that.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, tableName);
    }
}
