package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.metedata.table.ClassNbTable;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 解析上下文
 * tableKf 和 field(table) 会产生依赖关系
 * <p>
 * 解析a表中有属性p1 依赖b表
 * 解析b表有属性p2 依赖a表
 * 流程:
 * 解析a-> 放入半成品池, 解析b 放入半成品池，b中解析a重半成品池中取数据，完成b解析 a拿到b 后完成解析
 *
 * @author hperfect
 * @date 2022/11/29 14:11
 */
@Data
public class ParseContext {
    Map<Class<?>, ClassNbTable> cache = new HashMap<>();

    public ClassNbTable createClassNbTable(Class<?> tableClazz) {
        return cache.computeIfAbsent(tableClazz, k -> new ClassNbTable(tableClazz));
    }


    public ClassNbTable getTableInfo(Class<?> tableClazz) {
        return cache.get(tableClazz);
    }

}
