package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.enums.NbOrderType;
import cn.hperfect.nbquerier.enums.NullsPosition;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/12/20 1:09 下午
 */
@Data
@NoArgsConstructor
public class OrderInfoStr {
    private String order;
    private String orderBy;

    public OrderInfoStr(String order, String orderBy) {
        this.order = order;
        this.orderBy = orderBy;
    }

    private NullsPosition nullsPosition;

    public static OrderInfoStr asc(String orderBy) {
        return new OrderInfoStr(NbOrderType.ASC.name(), orderBy);
    }
}
