package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.metedata.inter.INbTable;
import cn.hperfect.nbquerier.core.metedata.table.VirtualTable;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.enums.QueryType;
import cn.hperfect.nbquerier.enums.perm.PermType;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 表或者连表信息
 *
 * @author huanxi
 * @date 2020/10/29 5:42 下午
 * @email 1355473748@qq.com
 */
@Getter
@Setter
public class NbQueryInfo {
    /**
     * 本次查询数据库类型
     */
    private DbType dbType;
    /**
     * 查询表名,或者子查询sql
     */
    private String sql;
    /**
     * 表
     */
    private INbTable table;
    /**
     * 子查询虚拟表
     */
    private VirtualTable virtualTable;

    /**
     * 子查询字段
     */
    private QueryFields queryFields = new QueryFields();

    private String alias;

    /**
     * 设置字段(自定或排除字段)
     */
    private String setField;
    /**
     * 附加字段,设置字段之后
     */
    private List<String> additionFields;
    /**
     * 排除字段,设置字段之后
     */
    private List<String> excludeFields;

    /**
     * 是否带删除字段
     */
    private boolean withDelete;
    /**
     * 是否构建过delete
     */
    private boolean buildDelete;
    /**
     * 是否是class
     */
    private boolean isClass;
    /**
     * 替换xx.*
     */
    private boolean fieldReplace = true;
    /**
     * 分页查询
     */
    private PageInfo pageInfo;
    /**
     * 权限字段的值
     */
    private Object permValue;
    /**
     * 数据域权限
     */
    private List<Object> dataScope;
    /**
     * 是否忽略数据权限(一般用于管理员)
     */
    private boolean ignoreDataScope;

    /**
     * 是否已经构建过数据权限，防止重复设置
     */
    private boolean buildDataScope;
    /**
     * 查询schema
     */
    private String schema;
    /**
     * 跟新数据,是否允许设置null
     */
    private boolean allowSetNull = false;
    /**
     * 查询类型,子查询？
     */
    private QueryType queryType;
    /**
     * 使用数据源
     */
    private String ds;

    /**
     * union All 列表
     */
    private List<NbQuerier<?>> unionAllQueries;

    private NbQuerier<?> fromQuerier;
    /**
     * 校验
     */
    private boolean validate = false;

    public PrimaryKey getPk() {
        INbTable nbTable = getTable();
        if (nbTable != null) {
            return nbTable.getPk();
        }
        return null;
    }

    public INbTable getTable() {
        if (isSub()) {
            return virtualTable;
        }
        Assert.notNull(table, "表单为空");
        return table;
    }


    /**
     * 获取主键名称
     *
     * @return
     */
    public String getPkName() {
        PrimaryKey pk = getPk();
        Assert.notNull(pk, "表:{}主键不存在", getTableName());
        return pk.getName();
    }

    public String getTableName() {
        INbTable table = getTable();
        if (table != null) {
            return table.getTableName();
        }
        return null;
    }

    public boolean isSub() {
        return queryType != null && queryType == QueryType.SUB;
    }

    public boolean isSoftDelete() {
        return !withDelete && table.getDeleteField() != null;
    }

    public INbField findField(String field) {
        return CollUtil.findOne(table.getFields(), i -> field.equals(i.getName()));
    }

    /**
     * 是否是用软删除
     *
     * @return
     */
    public boolean querySoftDelete() {
        return false;
    }

    /**
     * 表单的所有字段
     *
     * @return
     */
    public List<? extends INbField> getFields() {
        Assert.isFalse(isSub(), "不支持获取子查询字段");
        return table.getFields();
    }

    public String getSchemaTable(boolean useReplace) {
        String tableName = useReplace && StrUtil.isNotBlank(table.getReplaceTable()) ? table.getReplaceTable() : getTableName();
        return SqlUtils.withAlias(getSchema(), tableName);
    }

    public INbField getDeleteField() {
        return table.getDeleteField();
    }

    public INbField getPermField() {
        INbTable table = getTable();
        if (table != null) {
            return table.getPermField();
        }
        return null;
    }

    public PermType getPermType() {
        if (queryType == QueryType.FORM_QUERY) {
            return PermType.ALL;
        }
        INbTable table = getTable();
        if (table != null) {
            return table.getPermType();
        }
        return null;
    }

}
