package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;
import cn.hperfect.nbquerier.exceptions.NbSQLExecuteException;
import cn.hutool.core.io.IoUtil;
import lombok.Data;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * 批处理
 *
 * @author hperfect
 * @date 2023/1/10 17:36
 */
@Data
public class NbExecuteBatch implements INbExecuteBatch {
    /**
     * 到达批次后提交
     */
    private final int batchSize;
    private int currSize = 0;

    private INbTransaction tx;
    private PreparedStatement preparedStatement;

    private List<int[]> results = new ArrayList<>();

    public NbExecuteBatch(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        this.preparedStatement = preparedStatement;
    }

    public void commit() throws SQLException {
        if (tx != null) {
            tx.commit();
            IoUtil.close(tx);
        }
        IoUtil.close(preparedStatement);
    }

    @Override
    public INbTransaction getTx(NbQuerierConfiguration configuration) {
        if (tx != null) {
            return tx;
        }
        tx = configuration.newTx();
        return tx;
    }

    public void addBatch() throws SQLException {
        currSize++;
        preparedStatement.addBatch();
        if (batchSize > 0 && currSize >= batchSize) {
            executeBatch();
        }
    }

    private void executeBatch() throws SQLException {
        results.add(preparedStatement.executeBatch());
        currSize = 0;
    }


    @Override
    public void finish() {
        try {
            if (currSize > 0) {
                this.executeBatch();
            }
            commit();
        } catch (SQLException e) {
            throw new NbSQLExecuteException(e);
        } finally {
            IoUtil.close(this);
        }
    }

    @Override
    public void close() throws IOException {
        if (tx != null) {
            tx.close();
        }
    }
}
