package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.components.type.INbQueryType;
import cn.hperfect.nbquerier.toolkit.SqlUtils;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

@Data
public class JsonPropQueryItem implements IQueryItem {

    protected INbQueryType queryType;
    /**
     * 字段名称
     */
    protected String fieldName;
    protected String propName;
    protected String tableAlias;

    /**
     * (table.phone->'memo')::text
     *
     * @param alias
     * @return
     */
    @Override
    public String getExpr(String alias) {
        String af = SqlUtils.withAlias(alias, fieldName);
        Assert.notBlank(fieldName, "字段名称不能为空");
        Assert.notBlank(propName, "属性名称不能为空");
        Assert.notNull(queryType, "查询类型不能为空");
        return StrUtil.format("({}->>'{}')::{}", af, StrUtil.toUnderlineCase(propName), queryType.getDbTypeSql());
    }

    @Override
    public String getExpr() {
        return getExpr(tableAlias);
    }

}
