package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.enums.JoinType;
import cn.hperfect.nbquerier.enums.SqlKeyword;
import cn.hperfect.nbquerier.toolkit.StringPool;
import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 11:19 下午
 */
@Data
@AllArgsConstructor
public class JoinTableRule implements ISqlSegment {
    private NbQueryInfo queryInfo;
    private JoinType joinType;
    private String on;
    /**
     * 横向子查询
     */
    private boolean lateral;

    @Override
    public String getSqlSegment() {
        String sqlSegment = joinType.getSqlSegment();
        if (lateral) {
            sqlSegment = sqlSegment + StringPool.SPACE + SqlKeyword.LATERAL;
        }
        return sqlSegment;
    }
}
