package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.config.NbQuerierConfiguration;
import cn.hperfect.nbquerier.core.transaction.INbTransaction;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * @author hperfect
 * @date 2023/1/10 19:15
 */
public interface INbExecuteBatch extends Closeable {
    void commit() throws SQLException;

    INbTransaction getTx();
    INbTransaction getTx(NbQuerierConfiguration configuration);

    void setTx(INbTransaction tx);

    void addBatch() throws SQLException;


    void finish();

    PreparedStatement getPreparedStatement();

    void setPreparedStatement(PreparedStatement preparedStatement) throws SQLException;
}
