package cn.hperfect.nbquerier.core.metedata;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.toolkit.StringPool;
import lombok.Data;

/**
 * 条件聚合
 * coalesce(count((select c where diff_last_day < 7)), 0)          as count_lt7
 *
 * @author hperfect
 * @date 2022/12/17 21:46
 */
@Data
public class ConditionAgg implements ISqlSegment {
//    外层函数
    /**
     * 条件
     */
    private ISqlSegment sqlSegment;

    private String alias;

    public ConditionAgg(ISqlSegment sqlSegment, String alias) {
        this.sqlSegment = sqlSegment;
        this.alias = alias;
    }

    @Override
    public String getSqlSegment() {
        return sqlSegment.getSqlSegment() + StringPool.SPACE + alias;
    }
}
