package cn.hperfect.nbquerier.core.func;

import cn.hperfect.nbquerier.core.conditions.ISqlSegment;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hutool.core.util.StrUtil;

/**
 * @author hperfect
 * @date 2022/12/18 10:34
 */
public interface BuildInFunc {
    static ISqlSegment count(ISqlSegment param1) {
        return () -> StrUtil.format("COUNT({})", param1.getSqlSegment());
    }

    static  ISqlSegment coalesce(NbQuerier<?> querier, ISqlSegment param1, QueryValParam param2) {
        return () -> {
            String param2Str = querier.formatVariable(param2);
            return StrUtil.format("COALESCE({},{})", param1.getSqlSegment(), param2Str);
        };
    }
}
