package cn.hperfect.nbquerier.core.components.type;

import cn.hperfect.nbquerier.core.conditions.segments.MergeSegments;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbDataType;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;

import java.util.List;

/**
 * @author hperfect
 * @date 2022/12/6 11:06
 */
public abstract class NbQueryTypeAdapter implements INbQueryType{
    @Override
    public DbDataType getDbDataType() {
        return null;
    }

    @Override
    public Object convert(Object value) throws TypeConvertException {
        return null;
    }

    @Override
    public String getDbTypeSql() {
        return null;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void whereLike(NbQuerier<?> querier, MergeSegments expression, String name, Object value) {

    }

    @Override
    public List<QueryRuleEnum> getQueryRules() {
        return null;
    }

    @Override
    public boolean orderAble() {
        return true;
    }
}
