package cn.hperfect.nbquerier.core.components.result.json;

import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;

public class HutoolJsonSerializer implements NbJsonSerializer {
    JSONConfig jsonConfig = JSONConfig.create().setDateFormat("yyyy-MM-dd HH:mm:ss");
    @Override
    public String serialize(Object t) {
        return JSONUtil.toJsonStr(t, jsonConfig);
    }

    @Override
    public <T> T deserialize(String jsonStr, Class<T> clazz) {
        return JSONUtil.toBean(jsonStr, clazz);
    }

}
