package cn.hperfect.nbquerier.core.components.result;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSONUtil;
import org.postgresql.util.PGobject;

import java.sql.*;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 结果集处理
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 10:55 上午
 */
public class DefaultResultSetHandler implements IResultSetHandler {
    private final NbQuerierProperties config;

    public DefaultResultSetHandler(NbQuerierProperties config) {
        this.config = config;
    }

    @Override
    public List<LinkedHashMap<String, Object>> toMap(ResultSet rs) throws SQLException {
        List<LinkedHashMap<String, Object>> maps = new ArrayList<>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<>();
            int columnCount = md.getColumnCount();
            for (int i = 1; i <= columnCount; i++) {
                Object object = rs.getObject(i);
                String typeName = md.getColumnTypeName(i);
                Object value = null;
                if (object != null) {
                    if (object instanceof Array) {
                        value = ((Array) object).getArray();
                    } else if (object instanceof Timestamp) {
                        value = Convert.toLocalDateTime(object);
                    } else if ("json".equals(typeName) || "jsonb".equals(typeName)) {
                        //json 处理
                        if (config.getDbType() == DbType.PG_NG) {
                            if (JSONUtil.isJsonArray(object.toString())) {
                                value = JSONUtil.parseArray(object);
                            } else {
                                value = JSONUtil.parseObj(object);
                            }
                        } else {
                            //判断是否存在PGobject
                            if (object instanceof PGobject) {
                                PGobject pGobject = (PGobject) object;
                                if (JSONUtil.isJsonArray(pGobject.getValue())) {
                                    value = JSONUtil.parseArray(pGobject.getValue());
                                } else if (JSONUtil.isJson(pGobject.getValue())) {
                                    value = JSONUtil.parseObj(pGobject.getValue());
                                }
                            }
                        }
                    } else {
                        value = object;
                    }
                }
                rowData.put(md.getColumnLabel(i), value);
            }
            maps.add(rowData);
        }

        return maps;
    }


    Object handlerPGobject(Object value) {
        if (value == null) {
            return null;
        }
        if (config.getDbType() == DbType.POSTGRE_SQL) {

        }
        return value;
    }
}
