package cn.hperfect.nbquerier.core.components.interceptor.impl;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.FillStrategy;
import cn.hperfect.nbquerier.core.components.interceptor.INbInterceptor;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;

import java.util.List;
import java.util.Map;

/**
 * 填充器
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 1:25 下午
 */
public class FillInterceptor implements INbInterceptor {
    /**
     * 填充
     * 1. 更新填充
     * 2. 保存填充
     *
     * @param fields
     * @param dataList
     * @param update
     */
    private void doFill(List<? extends INbField> fields, List<Map<String, Object>> dataList, boolean update) {
        boolean isSave = !update;
        for (INbField field : fields) {
            //获取填充策略
            FillStrategy fillStrategy = field.getFillStrategy();
            if (fillStrategy == null) {
                continue;
            }
            if (fillStrategy.isSaveFill() && isSave || fillStrategy.isUpdateFill() && update) {
                String name = field.getName();
                for (Map<String, Object> map : dataList) {
                    Object value = fillStrategy.getApplier().getValue();
                    if (fillStrategy.getFillType() == FillStrategy.FillType.COVER || map.get(name) == null) {
                        map.put(name, value);
                    }
                }
            }
        }
    }

    @Override
    public void doBeforeSave(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        //创建时间填充,更新时间填充
        doFill(nbQueryInfo.getFields(), dataList, false);
    }

    @Override
    public void doBeforeUpdate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        doFill(nbQueryInfo.getFields(), dataList, true);
    }
}
