package cn.hperfect.nbquerier.core.components.interceptor.impl;

import cn.hperfect.nbquerier.core.components.interceptor.INbInterceptor;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.ValidateRule;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.registry.ValidatorRegistry;
import cn.hperfect.nbquerier.enums.NbFieldType;
import cn.hperfect.nbquerier.exceptions.ConstraintException;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;

import java.util.List;
import java.util.Map;

/**
 * 约束检查器
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/27 10:48 上午
 */
public class ConstraintInterceptor implements INbInterceptor {

    @Override
    public void doBeforeUpdate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (!nbQueryInfo.isValidate()) {
            return;
        }
        validate(nbQueryInfo, dataList, true);
    }

    @Override
    public void doBeforeSave(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
        if (!nbQueryInfo.isValidate()) {
            return;
        }
        validate(nbQueryInfo, dataList, false);
    }

    /**
     * 数据保存,更新链
     *
     * @param nbQueryInfo
     * @param dataList
     * @param isUpdate
     */
    private void validate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList, boolean isUpdate) {
        for (INbField field : nbQueryInfo.getFields()) {
            //必填约束检测
            if (field.getFieldType() == NbFieldType.NORMAL && CollUtil.isNotEmpty(field.getValidateRules())) {
                //规则校验
                for (ValidateRule validateRule : field.getValidateRules()) {
                    IValidator iValidator = ValidatorRegistry.getValidator(validateRule.getName());
                    Assert.notNull(iValidator, "校验器:{},不存在", validateRule.getName());
                    try {
                        if (isUpdate) {
                            iValidator.doUpdateValidate(validateRule.getParams(), nbQueryInfo, field, dataList);
                        } else {
                            iValidator.doSaveValidate(validateRule.getParams(), nbQueryInfo, field, dataList);
                        }
                    } catch (ConstraintException constraintException) {

                        if (StrUtil.isNotBlank(validateRule.getMsg())) {
                            throw new IllegalArgumentException(validateRule.getMsg());
                        } else {
                            throw constraintException;
                        }
                    }
                }
            }
        }
    }
}
