package cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl;

import cn.hperfect.nbquerier.cons.ValidatorCons;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.QueryRuleEnum;
import cn.hperfect.nbquerier.exceptions.ConstraintException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;

import java.util.List;
import java.util.Map;

/**
 * 查重,非空，json结构检查
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/4 10:28 上午
 */
public enum UniqueValidator implements IValidator {

    /**
     * 实例
     */
    INSTANCE;

    @Override
    public void doUpdateValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        doValidate(tableInfo, nbField, dataList, true);
    }

    @Override
    public void doSaveValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        doValidate(tableInfo, nbField, dataList, false);
    }

    private void doValidate(NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList, boolean isUpdate) {
        String name = nbField.getName();
        String pkName = tableInfo.getPkName();
        for (Map<String, Object> map : dataList) {
            Object value = map.get(name);
            Assert.isFalse(!isUpdate && StrUtil.isBlankIfStr(value), "新增时,查重字段不能为空");
            Object pkValue = map.get(pkName);
            //不校验
            if (pkValue == null || value == null) {
                return;
            }
            //特殊类型处理
            boolean exist = NbQuerier.table(tableInfo)
                    .where(name, value, true)
                    .with(isUpdate, i -> {
                        //查找主键值
                        i.where(pkName, QueryRuleEnum.NE, pkValue, true);
                    })
                    .exist();
            if (exist) {
                throw new ConstraintException(nbField, "存在值:" + value, tableInfo.getTableName());
            }
        }
    }

    @Override
    public String getName() {
        return ValidatorCons.VALIDATOR_NAME_UNIQUE;
    }
}
