package cn.hperfect.nbquerier.core.components.interceptor.components.validator.impl;

import cn.hperfect.nbquerier.cons.ValidatorCons;
import cn.hperfect.nbquerier.core.components.interceptor.components.validator.IValidator;
import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.exceptions.ConstraintException;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;
import cn.hutool.core.util.StrUtil;

import java.util.List;
import java.util.Map;

/**
 * @author huanxi
 * @version 1.0
 * @date 2022/1/10 10:40 上午
 */
public class NotNullValidator implements IValidator {


    @Override
    public void doUpdateValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        try {
            String name = nbField.getName();
            for (Map<String, Object> map : dataList) {
                if (map.containsKey(name)) {
                    Object value = map.get(name);
                    if (StrUtil.isBlankIfStr(value) || nbField.getQueryType().convert(value) == null) {
                        throw new ConstraintException(nbField, "数据不能为空",tableInfo.getTableName());
                    }
                }
            }
        } catch (TypeConvertException throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }

    @Override
    public void doSaveValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList) {
        try {
            String name = nbField.getName();
            for (Map<String, Object> map : dataList) {
                Object value = map.get(name);
                if (StrUtil.isBlankIfStr(value) ||
                        nbField.getQueryType().convert(value) == null) {
                    throw new ConstraintException(nbField, "数据不能为空", tableInfo.getTableName());
                }
            }
        } catch (TypeConvertException throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }


    @Override
    public String getName() {
        return ValidatorCons.VALIDATOR_NAME_NOT_NULL;
    }
}
