package cn.hperfect.nbquerier.core.components.interceptor.components.validator;


import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;
import cn.hperfect.nbquerier.core.metedata.inter.INbField;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;

import java.util.List;
import java.util.Map;

/**
 * 查重,非空，json结构检查
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/4 10:28 上午
 */
public interface IValidator {
    /**
     * 数据验证
     *
     * @param params
     * @param tableInfo
     * @param nbField
     * @param dataList
     */

    void doUpdateValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList);

    void doSaveValidate(Map<String, Object> params, NbQueryInfo tableInfo, INbField nbField, List<Map<String, Object>> dataList);

    /**
     * 验证器名称
     *
     * @return
     */
    String getName();
}
