package cn.hperfect.nbquerier.core.components.interceptor.components.fill;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;

/**
 * 字段填充策略
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 2:13 下午
 */
@Data
@AllArgsConstructor
public class FillStrategy implements Serializable {

    public enum FillType {
        /**
         * 填充
         */
        FILL,
        /**
         * 覆盖
         */
        COVER;
    }

    /**
     * 保存是否填充
     */
    private boolean saveFill;

    private boolean updateFill;

    private FillType fillType;
    /**
     * 数据获取器
     */
    private IFieldApplier applier;
}
