package cn.hperfect.nbquerier.core.components.interceptor.components.fill;

import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.SnowflakeIdApplier;
import cn.hperfect.nbquerier.core.components.interceptor.components.fill.applier.TimeApplier;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 填充策略仓库
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 2:36 下午
 */
public class FieldFillStrategyRegistry {

    public static final String TIME_APPLIER_NAME = "NOW_TIME_APPLIER";
    public static final String SNOWFLAKE_APPLIER_NAME = "ID_APPLIER";
    private TimeApplier timeApplier;
    private SnowflakeIdApplier snowflakeIdApplier;

    private Map<String, IFieldApplier> APPLIER_MAP = new HashMap<>();
    /**
     * 主键填充策略
     */
    @Getter
    @Setter
    private FillStrategy pkStrategy;
    @Getter
    @Setter
    private FillStrategy updateTimeStrategy;
    @Getter
    @Setter
    private FillStrategy createTimeStrategy;

    public FieldFillStrategyRegistry() {

    }


    public void init(SnowflakeIdApplier snowflakeIdApplier) {
        this.timeApplier = new TimeApplier();
        this.snowflakeIdApplier = snowflakeIdApplier;
        APPLIER_MAP.put(SNOWFLAKE_APPLIER_NAME, snowflakeIdApplier);
        APPLIER_MAP.put(TIME_APPLIER_NAME, timeApplier);
        pkStrategy = new FillStrategy(true, false, FillStrategy.FillType.FILL, snowflakeIdApplier);
        updateTimeStrategy = new FillStrategy(true, true, FillStrategy.FillType.COVER, timeApplier);
        createTimeStrategy = new FillStrategy(true, false, FillStrategy.FillType.COVER, timeApplier);
    }


    /**
     * 主键填充策略
     *
     * @return
     */
    public FillStrategy getIdSnowflakeStrategy() {
        return pkStrategy;
    }

    /**
     * 获取 值生成器
     *
     * @param name
     * @return
     */
    public IFieldApplier getFieldApplier(String name) {
        return APPLIER_MAP.get(name);
    }

}
