package cn.hperfect.nbquerier.core.components.interceptor;

import cn.hperfect.nbquerier.core.metedata.NbQueryInfo;

import java.util.List;
import java.util.Map;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/26 12:18 下午
 */
public interface INbInterceptor {
    /**
     * 更新单条数据之前
     *
     * @param nbQueryInfo
     * @param dataList    批量更新数据
     */
    default void doBeforeUpdate(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {
    }

    /**
     * 保存之前
     *
     * @param nbQueryInfo 查询信息
     * @param dataList    数据列表
     */
    default void doBeforeSave(NbQueryInfo nbQueryInfo, List<Map<String, Object>> dataList) {

    }

    default void doQueryBefore(NbQueryInfo nbQueryInfo) {

    }

    //todo doBeforeDelete
}
