package cn.hperfect.nbquerier.core.components.executor.options;

import cn.hperfect.nbquerier.core.metedata.INbExecuteBatch;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author hperfect
 * @date 2023/1/10 17:44
 */
@Data
@Accessors(chain = true)
public class DoUpdateOptions {
    private String dsName;
    private String sql;
    private List<QueryValParam> params;
    private INbExecuteBatch batch;
    /**
     * 是否关闭连接
     */
    private boolean autoClose = true;

    public DoUpdateOptions setBatch(INbExecuteBatch batch) {
        if (batch != null) {
            this.batch = batch;
            //由batch 去关闭
            autoClose = false;
        }
        return this;
    }
}
