package cn.hperfect.nbquerier.core.components.executor;

import cn.hperfect.nbquerier.core.components.executor.options.DoQueryOptions;
import cn.hperfect.nbquerier.core.components.executor.options.DoUpdateOptions;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.core.metedata.QueryValParam;
import cn.hperfect.nbquerier.enums.ResultType;

import java.util.List;
import java.util.Map;

/**
 * (事务)数据源+sql+参数 -> 执行
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/11/24 10:49 上午
 */
public interface INbExecutor {
    /**
     * 执行查询
     *
     * @param dsName
     * @param sql
     * @param params
     * @return
     */
    default <T> T doQuery(String dsName, String sql, List<QueryValParam> params, ResultType resultType){
        return doQuery(new DoQueryOptions().setDsName(dsName).setSql(sql).setParams(params).setResultType(resultType));
    }

    <T> T doQuery(DoQueryOptions options);
    <T> T doQuery(String sql);


    /**
     * 执行更新sql
     *
     * @param sql
     * @param params
     * @return
     */
    default int doUpdate(String dsName, String sql, List<QueryValParam> params, boolean close) {
        return doUpdate(new DoUpdateOptions()
                .setDsName(dsName)
                .setSql(sql)
                .setParams(params)
                .setAutoClose(close)
        );
    }

    int doUpdate(DoUpdateOptions options);

    default int doUpdate(String dsName, String sql, List<QueryValParam> params) {
        return doUpdate(dsName, sql, params, true);
    }

    /**
     * 更新
     *
     * @param sql
     * @return
     */
    default int doUpdate(String sql) {
        return doUpdate(new DoUpdateOptions().setSql(sql));
    }

    /**
     * 批量插入
     *
     * @param querier
     * @param maps
     * @param params
     * @return
     */
    int insertBatch(NbQuerier<?> querier, List<Map<String, Object>> maps, List<QueryValParam> params);

}
