package cn.hperfect.nbquerier.core.components.dialect;

import cn.hperfect.nbquerier.config.properties.NbQuerierProperties;
import cn.hperfect.nbquerier.core.querier.NbQuerier;
import cn.hperfect.nbquerier.enums.DbType;
import cn.hperfect.nbquerier.exceptions.NbSQLMessageException;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;

import java.util.List;

/**
 * 方言组件
 *
 * @author huanxi
 * @version 1.0
 * @date 2021/12/8 6:39 下午
 */
public class DefaultDialectWare implements IDialectWare {

    private final NbQuerierProperties config;

    private static final List<String> MYSQL_KEYS = ListUtil.toList("show");
    private static final List<String> PG_KEYS = ListUtil.toList("order");

    public DefaultDialectWare(NbQuerierProperties config) {
        this.config = config;
    }

    @Override
    public <T> void limit(NbQuerier<T> querier, int offset, int length) {
        DbType dbType = config.getDbType();
        switch (dbType) {
            case PG_NG:
            case POSTGRE_SQL:
                querier.last(StrUtil.format("LIMIT {} offset {}", length, offset));
                break;
            case MYSQL:
                querier.last(StrUtil.format("LIMIT {},{}", offset, length));
                break;
            default:
                throw new NbSQLMessageException("未实现数据库类型为:{}的limit(int,int)方法", dbType.getDb());
        }
    }

    @Override
    public String quotSqlKey(String key) {
        DbType dbType = config.getDbType();
        switch (dbType) {
            case MYSQL:
                if (MYSQL_KEYS.contains(key)) {
                    return StrUtil.format("`{}`", key);
                }
                break;
            case POSTGRE_SQL:
                if (PG_KEYS.contains(key)) {
                    return StrUtil.format("'{}'", key);
                }
            default:

        }
        return key;
    }
}
