package cn.hperfect.nbquerier.core.components.convertor;

import cn.hperfect.nbquerier.core.metedata.field.ClassNbField;
import cn.hperfect.nbquerier.enums.INbEnum;
import cn.hperfect.nbquerier.exceptions.TypeConvertException;

/**
 * @author huanxi
 * @version 1.0
 * @date 2021/11/29 11:57 上午
 */
public enum MapEnumConvertor implements ITypeConvertor {
    /**
     * 实例
     */
    INSTANCE;

    @Override
    public Object convert(ClassNbField classNbField, Object value) throws TypeConvertException {
        if (value instanceof String) {
            return value;
        }
        if (value != null) {
            INbEnum nbEnum = (INbEnum) value;
            return nbEnum.getValue();
        }
        return null;
    }
}
